﻿using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class REFERRAL_REGDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public REFERRAL_REGDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public REFERRAL_REG GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            REFERRAL_REG objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_REG_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        //public REFERRAL_REG GetItemByPatientIcn(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string PatientIcn)
        //{
        //    REFERRAL_REG objReturn = null;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            objReturn = dbContext.usp_REFERRAL_REG_getitemByPatientIcn(CURRENT_USER, CURRENT_REGISTRY_ID, PatientIcn).FirstOrDefault();
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn;
        //}

        public List<REFERRAL_REG> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<REFERRAL_REG> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_REG_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REFERRAL_REG objSave)
        {
            Int32? objReturn = objSave.REFERRAL_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_REFERRAL_REG_save(
                        CURRENT_USER,
                        CURRENT_REGISTRY_ID,
                        objSave.REFERRAL_ID,
                        //objSave.STD_REFERRALSTS_ID,
                        //objSave.STD_REGISTRY_ID,
                        //objSave.PATIENT_ID,
                        //objSave.STD_INSTITUTION_ID,
                        //objSave.REFERRAL_DATE,
                        //objSave.REFERRAL_CLASS_TEXT,
                        objSave.PROVIDER_ID_NUMBER,
                        objSave.PROVIDER_NAME,
                        objSave.PROVIDER_PHONE,
                        objSave.PROVIDER_EMAIL,
                        objSave.CREATEDBY,
                        DateTime.Now,
                        objSave.UPDATEDBY,
                        DateTime.Now,
                        objSave.COMMENT_TEXT,
                        objSave.ADDRESS_LINE1,
                        objSave.ADDRESS_LINE2,
                        objSave.ADDRESS_LINE3,
                        objSave.CITY,
                        objSave.COUNTRY,
                        objSave.COUNTY,
                        objSave.POSTAL_CODE,
                        objSave.STATE,
                        objSave.VAMC_CONTACT_EMAIL,
                        objSave.VAMC_CONTACT_NAME,
                        objSave.VAMC_CONTACT_PHONE,
                        objSave.ZIP_PLUS_4,
                        objSave.VAMC_CONTACT_FAX,
                        objSave.PROVIDER_ADDRESS_LINE1,
                        objSave.PROVIDER_ADDRESS_LINE2,
                        objSave.PROVIDER_ADDRESS_LINE3,
                        objSave.PROVIDER_CITY,
                        objSave.PROVIDER_STATE,
                        objSave.PROVIDER_COUNTY,
                        objSave.PROVIDER_COUNTRY,
                        objSave.PROVIDER_POSTAL_CODE,
                        objSave.PROVIDER_ZIP_PLUS_4,
                        objSave.PROVIDER_FAX,
                        objSave.STD_REMINDERCLASS_ID,
                        objSave.REVIEW_BY,
                        objSave.REVIEW_DATE,
                        objSave.DUPLICATE_FLAG,
                        objSave.ORDERBY_PROVIDER_ID_NUMBER,
                        objSave.ORDERBY_PROVIDER_NAME,
                        objSave.ORDERBY_PROVIDER_PHONE,
                        objSave.ORDERBY_PROVIDER_EMAIL,
                        objSave.ORDERBY_PROVIDER_ADDRESS_LINE1,
                        objSave.ORDERBY_PROVIDER_ADDRESS_LINE2,
                        objSave.ORDERBY_PROVIDER_ADDRESS_LINE3,
                        objSave.ORDERBY_PROVIDER_CITY,
                        objSave.ORDERBY_PROVIDER_STATE,
                        objSave.ORDERBY_PROVIDER_COUNTRY,
                        objSave.ORDERBY_PROVIDER_POSTAL_CODE,
                        objSave.ORDERBY_PROVIDER_ZIP_PLUS_4,
                        objSave.ORDERBY_PROVIDER_FAX,
                        objSave.STD_REFERRALRANK_ID);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_REFERRAL_REG_delete(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public REFERRAL_REG GetItemComplete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            REFERRAL_REG objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_REG_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).FirstOrDefault();
                    if (objReturn != null)
                    {
                        if (objReturn.STD_REGISTRY_ID > 0)
                            objReturn.STD_REGISTRY = dbContext.usp_STD_REGISTRY_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STD_REGISTRY_ID).FirstOrDefault();

                        if (objReturn.PATIENT_ID > 0)
                        {
                            objReturn.PATIENT = dbContext.usp_PATIENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.PATIENT_ID).FirstOrDefault();
                            //objReturn.SPATIENT = dbContext.usp_SPATIENT_getitemByICN(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.PATIENT.PatientICN).FirstOrDefault();
                        }

                        //if (objReturn.STD_REFERRAL_REGSTS_ID > 0)
                        //    objReturn.STD_REFERRAL_REGSTS = dbContext.usp_STD_REFERRAL_REGSTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STD_REFERRAL_REGSTS_ID).FirstOrDefault();

                        //if (objReturn.PROVIDER_ID > 0)
                        //    objReturn.SStaff_SStaff = dbContext.usp_SStaff_SStaff_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.PROVIDER_ID).FirstOrDefault();
                    }
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        //public List<REFERRAL_REG> GetItemsByRegistryStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_REFERRAL_REGSTS_ID)
        //{
        //    List<REFERRAL_REG> objReturn = null;
        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            objReturn = dbContext.usp_REFERRAL_REG_getitemsByRegistryStatus(CURRENT_USER, CURRENT_REGISTRY_ID, STD_REFERRAL_REGSTS_ID).ToList();
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn;
        //}

        //public List<REFERRAL_REGcommon> GetItemsCommonByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION, int START_ROW, int MAX_ROWS)
        //public List<REFERRAL_REGcommon> GetItemsCommonByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        //{
        //    List<REFERRAL_REGcommon> objReturn = null;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            //objReturn = dbContext.usp_REFERRAL_REG_getitemsCommonByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, START_ROW, MAX_ROWS).ToList();
        //            objReturn = dbContext.usp_REFERRAL_REG_getitemsCommonByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn;
        //}

        //public List<REFERRAL_REGcommon> GetItemsCommonByPatient(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        //{
        //    List<REFERRAL_REGcommon> objReturn = null;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            objReturn = dbContext.usp_REFERRAL_REG_getitemsByPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).ToList();
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn;
        //}

        //public List<REFERRAL_REGcommon> GetItemsCommonByProvider(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PROVIDER_ID)
        //{
        //    List<REFERRAL_REGcommon> objReturn = null;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            objReturn = dbContext.usp_REFERRAL_REG_getitemsByProvider(CURRENT_USER, CURRENT_REGISTRY_ID, PROVIDER_ID).ToList();
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn;
        //}

        public REFERRAL_REG GetItemByReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            REFERRAL_REG objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_REG_getitemByReferral(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public REFERRAL_REG GetItemByRegistryPatient(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            REFERRAL_REG objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_REG_getitemByRegistryPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        //public Int32 SaveManual(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID, Int32 PROVIDER_ID)
        //{
        //    Int32? objReturn = 0;

        //    try
        //    {
        //        Int32? providerId = null;
        //        if (providerId > 0) providerId = PROVIDER_ID;

        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            dbContext.usp_REFERRAL_REG_saveManual(CURRENT_USER,
        //                CURRENT_REGISTRY_ID,
        //                PATIENT_ID,
        //                providerId,
        //                ref objReturn);
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn.GetValueOrDefault();
        //}

        //public Boolean UpdateStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_REG_ID, Int32 STD_REFERRAL_REGSTS_ID)
        //{
        //    Boolean objReturn = false;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            dbContext.usp_REFERRAL_REG_updateStatus(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_REG_ID, STD_REFERRAL_REGSTS_ID);
        //            objReturn = true;
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn;
        //}

        #endregion
    }
}
